﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.Collections.ObjectModel;
using System.Text;
using System.ComponentModel;

namespace ImageRotatorExtender
{
    /// <summary>
    /// Summary description for ExtenderControl1
    /// </summary>
    [
        TargetControlType(typeof(Image))
    ]
    public class ImageRotator : ExtenderControl
    {
        public ImageRotator()
        {
        }

        int _rotationInterval = 0;
        [DefaultValue(3), DisplayName("RotationInterval(seconds))")]
        public int RotationInterval 
        { 
            get
            {
                if (_rotationInterval == 0)
                {
                    // ustawia wartość domyślną
                    _rotationInterval = 3;
                    return _rotationInterval;
                }
                else
                {
                    return _rotationInterval;
                }
            }
            set 
            {
                _rotationInterval = value;
            } 
        }

        public string ImageList { get; set; }

        protected override IEnumerable<ScriptDescriptor>
                GetScriptDescriptors(System.Web.UI.Control targetControl)
        {
            ScriptBehaviorDescriptor descriptor = new ScriptBehaviorDescriptor(
                "ImageRotatorExtender.ImageRotator", targetControl.ClientID);
            descriptor.AddProperty("rotationInterval", RotationInterval);
            if (!string.IsNullOrEmpty(ImageList))
            {
                descriptor.AddProperty("imageList",ImageList.Split(','));
            }
            yield return descriptor;
        }

        // generuje referencję do skryptu
        protected override IEnumerable<ScriptReference>
                GetScriptReferences()
        {
            yield return new ScriptReference(
                "ImageRotatorExtender.ImageRotator.js", 
                this.GetType().Assembly.FullName);
        }
    }
}